<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

// Route to serve files from Constituency folder
Route::get('storage/constituency/{constituency}/{booth}/{filename}', function ($constituency, $booth, $filename) {
    $constituencyRoot = config('filesystems.disks.constituency.root');
    $filePath = $constituencyRoot . '/' . $constituency . '/' . $booth . '/' . $filename;
    
    if (!file_exists($filePath)) {
        abort(404, 'File not found');
    }
    
    return response()->download($filePath);
})->where('filename', '.*')->name('constituency.file');
