/**
 * @license
 * Copyright 2025 Google Inc.
 * SPDX-License-Identifier: Apache-2.0
 */
import type { AdapterState, BluetoothEmulation, PreconnectedPeripheral } from '../api/BluetoothEmulation.js';
import type { Connection } from './Connection.js';
/**
 * @internal
 */
export declare class CdpBluetoothEmulation implements BluetoothEmulation {
    #private;
    constructor(connection: Connection);
    emulateAdapter(state: AdapterState, leSupported?: boolean): Promise<void>;
    disableEmulation(): Promise<void>;
    simulatePreconnectedPeripheral(preconnectedPeripheral: PreconnectedPeripheral): Promise<void>;
}
//# sourceMappingURL=BluetoothEmulation.d.ts.map