#!/bin/bash

# Development Deployment Script
echo "🚀 Starting Development Deployment..."

# Switch to development environment
./env-manager.sh development

# Install/Update dependencies
echo "📦 Installing dependencies..."
composer install --no-prod --optimize-autoloader

# Run database migrations
echo "🗄️ Running database migrations..."
php artisan migrate --force

# Seed database with test data (development only)
echo "🌱 Seeding database..."
php artisan db:seed

# Clear and cache configs
echo "🧹 Clearing caches..."
php artisan optimize:clear
php artisan config:cache
php artisan route:cache

# Set permissions
echo "🔒 Setting permissions..."
chmod -R 775 storage bootstrap/cache

echo "✅ Development deployment complete!"
echo "🌐 Server can be started with: php artisan serve"