<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Survey extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'title',
        'survey_date',
    ];

    protected $casts = [
        'survey_date' => 'datetime',
    ];

    /**
     * Get all voters associated with this survey
     */
    public function surveyVoters()
    {
        return $this->hasMany(SurveyVoter::class);
    }

    /**
     * Get count of voters by rating
     */
    public function getVoterCountsByRating()
    {
        return $this->surveyVoters()
            ->selectRaw('rating, count(*) as count')
            ->groupBy('rating')
            ->pluck('count', 'rating')
            ->toArray();
    }
}
