# PDF Import Quick Reference

## Updated Response Format

### API Endpoint
```http
POST http://localhost:8000/api/pdf-import/upload
Content-Type: multipart/form-data

Body:
- pdf_file: [Electoral Roll PDF]
- process_immediately: true
- uploaded_by: 1
```

### Response Structure

```json
{
  "status": "success",
  "message": "PDF processed successfully",
  "data": {
    "import_log": {
      "id": 1,
      "original_filename": "2025-EROLLGEN-U07-6-FinalRoll-Revisi...",
      "stored_filename": "uuid_timestamp.pdf",
      "status": "completed",
      "total_voters": 0,
      "imported_voters": 0,
      "failed_voters": 0,
      "import_summary": {
        "total_pages": 0,
        "booths_processed": 1,
        "streets_processed": 15,
        "net_electors": {
          "male": 630,
          "female": 642,
          "third_gender": 0,
          "total": 1272
        }
      }
    },
    "processed_booth": {
      "id": 1,
      "booth_number": "10",
      "booth_address": "Dr. B.R. Ambedkar Govt. Middle School (Western side-North)",
      "is_deleted": false,
      "created_at": "2025-11-11T10:30:45.000000Z",
      "updated_at": "2025-11-11T10:30:45.000000Z",
      "streets": [
        {
          "id": 1,
          "street_name": "1-DR.RADHAKRISHNAN NAGAR, PITCHAIVEERANPET",
          "booth_id": 1,
          "is_deleted": false,
          "created_at": "2025-11-11T10:30:46.000000Z",
          "updated_at": "2025-11-11T10:30:46.000000Z"
        },
        {
          "id": 2,
          "street_name": "2-1st Cross Street, Dr. Radhakrishnan Nagar",
          "booth_id": 1,
          "is_deleted": false,
          "created_at": "2025-11-11T10:30:46.000000Z",
          "updated_at": "2025-11-11T10:30:46.000000Z"
        }
        // ... more streets
      ]
    },
    "net_electors": {
      "male": 630,
      "female": 642,
      "third_gender": 0,
      "total": 1272
    }
  }
}
```

## What's Extracted from PDF

### Page 1 (Metadata)
- ✅ Part No. (Booth Number) from header: `Part No. : 10`
- ✅ Booth details from section 3: `10 - Dr. B.R. Ambedkar Govt. Middle School...`
- ✅ Street list from section 2: List of streets with Nagar/Street/Road/Cross/Lane

### Page 2 (Net Electors)
- ✅ Male voters count: `630`
- ✅ Female voters count: `642`
- ✅ Third gender count: `0`
- ✅ Total voters: `1272`

### Database Operations
- **Booths Table**: Insert or update booth by booth_number
- **Streets Table**: Insert streets with booth_id reference
- **Relationship**: Booth hasMany Streets

## Key Features

1. **Duplicate Prevention**: Won't insert booth or street if already exists with same name/number
2. **Relationship Loading**: Booth object includes all associated streets
3. **Net Electors Parsing**: Extracts voter statistics from page 2 table
4. **Statistics Tracking**: Returns comprehensive statistics in response

## Testing

### Check Database
```sql
-- View booths with street count
SELECT b.*, COUNT(s.id) as street_count 
FROM booths b 
LEFT JOIN streets s ON s.booth_id = b.id 
GROUP BY b.id;

-- View streets with booth info
SELECT s.*, b.booth_number, b.booth_address 
FROM streets s 
JOIN booths b ON s.booth_id = b.id 
ORDER BY s.id DESC;
```

### Check Logs
```bash
tail -f storage/logs/laravel.log | grep -E "(Booth|Street|Electors)"
```

Expected log entries:
- `Found Part No (Booth): 10`
- `Saved Booth`
- `Saved Street`
- `Extracted Net Electors`
- `PDF extraction completed`

## Next Phase: Voter Extraction

After verifying booth, streets, and net electors are correctly extracted, Phase 2 will implement:
- Extract voter data from page 4 onwards
- Parse voter details: Serial No, Voter ID, Name, Father/Husband, House, Age, Gender
- Bulk insert voters linked to booth

---

**Status**: Phase 1 Complete - Ready for testing! 🚀
