# Google Cloud Vision Setup - Quick Start

## Current Situation

**Tesseract OCR Results:**
- Extracted: 0-2 voters out of 25+ expected
- EPIC ID recognition: Poor (many nulls)
- Accuracy: ~10%

**Expected with Google Cloud Vision:**
- Extract: 20-25 voters (80-95% accuracy)
- EPIC ID recognition: Excellent
- Similar accuracy to ChatGPT

## Setup (5 minutes)

### Step 1: Get Google Cloud Credentials

1. Visit: https://console.cloud.google.com/
2. Create project or select existing
3. Enable "Cloud Vision API"
4. Create Service Account Key (JSON format)
5. Download the JSON file

### Step 2: Configure

```bash
# Copy credentials to storage
cp ~/Downloads/your-credentials.json "/Volumes/Workspace/Client Projects/ConstituencyApi/storage/app/google/vision-credentials.json"

# Add to .env (create if doesn't exist)
echo "OCR_ENGINE=google_vision" >> .env
echo "GOOGLE_VISION_CREDENTIALS_PATH=/Volumes/Workspace/Client Projects/ConstituencyApi/storage/app/google/vision-credentials.json" >> .env
```

### Step 3: Test

```bash
php artisan tinker --execute="
use App\Services\OcrService;
\$ocr = new OcrService();
\$words = \$ocr->extractStructuredData('Output/nellithope 3.png');
echo 'Engine: ' . config('services.ocr.engine') . PHP_EOL;
echo 'Words extracted: ' . count(\$words) . PHP_EOL;
"
```

### Step 4: Run Import

```bash
php artisan tinker --execute="
use App\Models\Voter;
use App\Jobs\ProcessVoterImageBatch;
Voter::query()->delete();
ProcessVoterImageBatch::dispatch('Output', 0, 1);
"

php artisan queue:work --once --queue=voter-processing
```

## Cost

- **First 1,000 images/month: FREE**
- Additional: $1.50 per 1,000 images
- Your 2 test images: **$0.00** (within free tier)

## Without Google Cloud Vision

If you prefer to stick with Tesseract (free but less accurate), I recommend:
1. Preprocessing images (increase contrast, denoise)
2. Using higher resolution scans (600 DPI instead of 300 DPI)
3. Manual review of extracted data

However, ChatGPT gets better results because it uses advanced vision AI, not basic OCR like Tesseract.

---

**Ready to proceed? Just provide the Google Cloud credentials JSON file!**
